/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.themes.meteor;

import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.utils.BaseWidget;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;

public interface MeteorWidget
extends BaseWidget {
    default public MeteorGuiTheme theme() {
        return (MeteorGuiTheme)this.getTheme();
    }

    default public void roundedQuad(GuiRenderer renderer, double x, double y, double width, double height, double radius, Color color) {
        double r = Math.min(Math.max(radius, 0.0), Math.min(width, height) / 2.0);
        if (r <= 0.5) {
            renderer.quad(x, y, width, height, color);
            return;
        }
        double d = r * 2.0;
        renderer.quad(x + r, y, Math.max(width - d, 0.0), height, color);
        renderer.quad(x, y + r, width, Math.max(height - d, 0.0), color);
        renderer.quad(x, y, d, d, GuiRenderer.CIRCLE, color);
        renderer.quad(x + width - d, y, d, d, GuiRenderer.CIRCLE, color);
        renderer.quad(x, y + height - d, d, d, GuiRenderer.CIRCLE, color);
        renderer.quad(x + width - d, y + height - d, d, d, GuiRenderer.CIRCLE, color);
    }

    default public void renderBackground(GuiRenderer renderer, WWidget widget, Color outlineColor, Color backgroundColor) {
        MeteorGuiTheme theme = this.theme();
        double border = Math.max(theme.scale(1.0), 1.0);
        double innerX = widget.x + border;
        double innerY = widget.y + border;
        double innerW = Math.max(0.0, widget.width - border * 2.0);
        double innerH = Math.max(0.0, widget.height - border * 2.0);
        double radius = Math.max(theme.scale(4.0), 2.0);
        if (innerW <= 0.0 || innerH <= 0.0) {
            this.roundedQuad(renderer, widget.x, widget.y, widget.width, widget.height, radius, outlineColor);
            return;
        }
        this.roundedQuad(renderer, widget.x, widget.y, widget.width, widget.height, radius, MeteorWidget.withAlpha(outlineColor, outlineColor.a + 6));
        this.roundedQuad(renderer, innerX, innerY, innerW, innerH, Math.max(radius - border, 1.0), MeteorWidget.withAlpha(backgroundColor, backgroundColor.a));
    }

    default public void renderBackground(GuiRenderer renderer, WWidget widget, boolean pressed, boolean mouseOver) {
        MeteorGuiTheme theme = this.theme();
        SettingColor outline = theme.outlineColor.get(pressed, mouseOver);
        SettingColor background = theme.backgroundColor.get(pressed, mouseOver);
        this.renderBackground(renderer, widget, outline, background);
        if (mouseOver || pressed) {
            double border = Math.max(theme.scale(1.0), 1.0);
            double innerW = Math.max(0.0, widget.width - border * 2.0);
            double innerH = Math.max(0.0, widget.height - border * 2.0);
            if (innerW > 0.0 && innerH > 0.0) {
                renderer.quad(widget.x + border, widget.y + border, innerW, innerH, MeteorWidget.withAlpha(theme.accentColor.get(), pressed ? 16 : 9));
            }
        }
    }

    private static Color withAlpha(Color color, int alpha) {
        return new Color(color.r, color.g, color.b, MeteorWidget.clamp(alpha));
    }

    private static int clamp(int value) {
        if (value < 0) {
            return 0;
        }
        return Math.min(value, 255);
    }
}

