/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.themes.meteor.widgets;

import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorWidget;
import meteordevelopment.meteorclient.gui.utils.AlignmentX;
import meteordevelopment.meteorclient.gui.widgets.pressable.WPressable;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class WMeteorModule
extends WPressable
implements MeteorWidget {
    private final Module module;
    private final String title;
    private double titleWidth;
    private double hoverProgress;
    private double activeProgress;

    public WMeteorModule(Module module, String title) {
        this.module = module;
        this.title = title;
        this.tooltip = module.description;
        if (module.isActive()) {
            this.activeProgress = 1.0;
            this.hoverProgress = 0.0;
        } else {
            this.activeProgress = 0.0;
            this.hoverProgress = 0.0;
        }
    }

    @Override
    public double pad() {
        return this.theme.scale(3.0);
    }

    @Override
    protected void onCalculateSize() {
        double pad = this.pad();
        if (this.titleWidth == 0.0) {
            this.titleWidth = this.theme.textWidth(this.title);
        }
        this.width = pad + this.titleWidth + pad;
        this.height = pad + this.theme.textHeight() + pad;
    }

    @Override
    protected void onPressed(int button) {
        if (button == 0) {
            this.module.toggle();
        } else if (button == 1) {
            MeteorClient.mc.method_1507((class_437)this.theme.moduleScreen(this.module));
        }
    }

    @Override
    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        MeteorGuiTheme theme = this.theme();
        double pad = this.pad();
        double border = Math.max(theme.scale(1.0), 1.0);
        double innerX = this.x + border;
        double innerY = this.y + border;
        double innerW = Math.max(0.0, this.width - border * 2.0);
        double innerH = Math.max(0.0, this.height - border * 2.0);
        this.hoverProgress += delta * 10.0 * (double)(this.mouseOver ? 1 : -1);
        this.hoverProgress = class_3532.method_15350((double)this.hoverProgress, (double)0.0, (double)1.0);
        this.activeProgress += delta * 8.0 * (double)(this.module.isActive() ? 1 : -1);
        this.activeProgress = class_3532.method_15350((double)this.activeProgress, (double)0.0, (double)1.0);
        SettingColor baseOutline = theme.outlineColor.get(false, false);
        Color baseBackground = WMeteorModule.shift(theme.backgroundColor.get(false, false), -2, -2, -2, 0);
        Color activeTint = theme.moduleBackground.get();
        double radius = Math.max(theme.scale(3.0), 2.0);
        this.roundedQuad(renderer, this.x, this.y, this.width, this.height, radius, WMeteorModule.mix(baseOutline, theme.accentColor.get(), this.activeProgress * 0.35 + this.hoverProgress * 0.12));
        this.roundedQuad(renderer, innerX, innerY, innerW, innerH, Math.max(radius - border, 1.0), baseBackground);
        if (this.activeProgress > 0.0 && innerW > 0.0 && innerH > 0.0) {
            this.roundedQuad(renderer, innerX, innerY, innerW, innerH, Math.max(radius - border, 1.0), WMeteorModule.withAlpha(activeTint, (int)Math.round((double)activeTint.a * this.activeProgress)));
        }
        if (this.hoverProgress > 0.0 && innerW > 0.0 && innerH > 0.0) {
            this.roundedQuad(renderer, innerX, innerY, innerW, innerH, Math.max(radius - border, 1.0), WMeteorModule.withAlpha(theme.accentColor.get(), (int)Math.round(10.0 * this.hoverProgress)));
        }
        if ((this.activeProgress > 0.0 || this.hoverProgress > 0.0) && innerH > 0.0) {
            int indicatorAlpha = (int)Math.round(124.0 * this.activeProgress + 54.0 * this.hoverProgress * (1.0 - this.activeProgress));
            double indicatorW = Math.max(theme.scale(2.0), 1.0);
            renderer.quad(innerX, innerY, indicatorW, innerH, WMeteorModule.withAlpha(theme.accentColor.get(), indicatorAlpha));
        }
        double x = this.x + pad;
        double w = this.width - pad * 2.0;
        if (theme.moduleAlignment.get() == AlignmentX.Center) {
            x += w / 2.0 - this.titleWidth / 2.0;
        } else if (theme.moduleAlignment.get() == AlignmentX.Right) {
            x += w - this.titleWidth;
        }
        double emphasis = Math.min(1.0, this.activeProgress * 0.85 + this.hoverProgress * 0.45);
        Color textColor = WMeteorModule.mix(theme.textColor.get(), theme.titleTextColor.get(), emphasis);
        if (this.activeProgress > 0.0) {
            textColor = WMeteorModule.mix(textColor, theme.accentColor.get(), this.activeProgress * 0.2);
        }
        renderer.text(this.title, x, this.y + pad, textColor, false);
    }

    private static Color withAlpha(Color color, int alpha) {
        return new Color(color.r, color.g, color.b, WMeteorModule.clamp(alpha));
    }

    private static Color mix(Color from, Color to, double t) {
        t = class_3532.method_15350((double)t, (double)0.0, (double)1.0);
        return new Color(WMeteorModule.clamp((int)Math.round((double)from.r + (double)(to.r - from.r) * t)), WMeteorModule.clamp((int)Math.round((double)from.g + (double)(to.g - from.g) * t)), WMeteorModule.clamp((int)Math.round((double)from.b + (double)(to.b - from.b) * t)), WMeteorModule.clamp((int)Math.round((double)from.a + (double)(to.a - from.a) * t)));
    }

    private static Color shift(Color color, int dr, int dg, int db, int da) {
        return new Color(WMeteorModule.clamp(color.r + dr), WMeteorModule.clamp(color.g + dg), WMeteorModule.clamp(color.b + db), WMeteorModule.clamp(color.a + da));
    }

    private static int clamp(int value) {
        if (value < 0) {
            return 0;
        }
        return Math.min(value, 255);
    }
}

