/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.themes.meteor.widgets;

import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorWidget;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WSection;
import meteordevelopment.meteorclient.gui.widgets.pressable.WTriangle;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class WMeteorSection
extends WSection {
    public WMeteorSection(String title, boolean expanded, WWidget headerWidget) {
        super(title, expanded, headerWidget);
    }

    @Override
    protected WSection.WHeader createHeader() {
        return new WMeteorHeader(this.title);
    }

    private static Color shift(Color color, int dr, int dg, int db, int da) {
        return new Color(WMeteorSection.clamp(color.r + dr), WMeteorSection.clamp(color.g + dg), WMeteorSection.clamp(color.b + db), WMeteorSection.clamp(color.a + da));
    }

    private static int clamp(int value) {
        if (value < 0) {
            return 0;
        }
        return Math.min(value, 255);
    }

    protected class WMeteorHeader
    extends WSection.WHeader {
        private WTriangle triangle;

        public WMeteorHeader(String title) {
            super(WMeteorSection.this, title);
        }

        @Override
        public void init() {
            this.spacing = this.theme.scale(4.0);
            this.add(this.theme.label(this.title, true)).expandX().centerY();
            if (WMeteorSection.this.headerWidget != null) {
                this.add(WMeteorSection.this.headerWidget).centerY();
            }
            this.triangle = new WHeaderTriangle();
            this.triangle.theme = this.theme;
            this.triangle.action = () -> this.onClick();
            this.add(this.triangle).centerY();
        }

        @Override
        protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
            MeteorGuiTheme theme = (MeteorGuiTheme)this.theme;
            Color bg = new Color(theme.backgroundColor.get(false, this.mouseOver, true));
            Color top = WMeteorSection.shift(bg, 10, 10, 12, 8);
            Color bottom = WMeteorSection.shift(bg, -6, -6, -8, 0);
            renderer.quad(this.x, this.y, this.width, this.height, top, top, bottom, bottom);
            renderer.quad(this.x, this.y + this.height - Math.max(theme.scale(1.0), 1.0), this.width, Math.max(theme.scale(1.0), 1.0), new Color(theme.separatorCenter.get()));
            this.triangle.rotation = (1.0 - WMeteorSection.this.animProgress) * -90.0;
        }
    }

    protected static class WHeaderTriangle
    extends WTriangle
    implements MeteorWidget {
        protected WHeaderTriangle() {
        }

        @Override
        protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
            renderer.rotatedQuad(this.x, this.y, this.width, this.height, this.rotation, GuiRenderer.TRIANGLE, this.theme().accentColor.get());
        }
    }
}

