/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.themes.meteor.widgets;

import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorWidget;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WWindow;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class WMeteorWindow
extends WWindow
implements MeteorWidget {
    public WMeteorWindow(WWidget icon, String title) {
        super(icon, title);
    }

    @Override
    protected WWindow.WHeader header(WWidget icon) {
        return new WMeteorHeader(icon);
    }

    @Override
    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        double bodyHeight;
        double border = Math.max(this.theme().scale(1.0), 1.0);
        double radius = Math.max(this.theme().scale(6.0), 3.0);
        double visibleHeight = this.header.height + Math.max(0.0, this.height - this.header.height) * this.animProgress;
        this.roundedQuad(renderer, this.x, this.y, this.width, visibleHeight, radius, WMeteorWindow.withAlpha(this.theme().outlineColor.get(), 84));
        if ((this.expanded || this.animProgress > 0.0) && (bodyHeight = Math.max(0.0, visibleHeight - this.header.height - border)) > 0.0) {
            Color bodyTop = WMeteorWindow.shift(this.theme().backgroundColor.get(), 4, 4, 8, 6);
            Color bodyBottom = WMeteorWindow.shift(this.theme().backgroundColor.get(), -2, -2, -4, 2);
            double bodyY = this.y + this.header.height;
            double bodyRadius = Math.max(radius - border, 1.0);
            this.roundedQuad(renderer, this.x + border, bodyY, this.width - border * 2.0, bodyHeight, bodyRadius, bodyTop);
            this.roundedQuad(renderer, this.x + border, bodyY, this.width - border * 2.0, bodyHeight, bodyRadius, WMeteorWindow.withAlpha(bodyBottom, bodyBottom.a));
            renderer.quad(this.x + border, bodyY, this.width - border * 2.0, Math.max(this.theme().scale(1.0), 1.0), WMeteorWindow.withAlpha(this.theme().outlineColor.get(), 56));
        }
    }

    private static Color withAlpha(Color color, int alpha) {
        return new Color(color.r, color.g, color.b, WMeteorWindow.clamp(alpha));
    }

    private static Color shift(Color color, int dr, int dg, int db, int da) {
        return new Color(WMeteorWindow.clamp(color.r + dr), WMeteorWindow.clamp(color.g + dg), WMeteorWindow.clamp(color.b + db), WMeteorWindow.clamp(color.a + da));
    }

    private static int clamp(int value) {
        if (value < 0) {
            return 0;
        }
        return Math.min(value, 255);
    }

    private class WMeteorHeader
    extends WWindow.WHeader {
        public WMeteorHeader(WWidget icon) {
            super(WMeteorWindow.this, icon);
        }

        @Override
        protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
            Color headerTop = this.mouseOver ? new Color(154, 92, 255, 182) : new Color(138, 78, 244, 168);
            Color headerBottom = this.mouseOver ? new Color(132, 76, 228, 170) : new Color(118, 66, 210, 154);
            double line = Math.max(WMeteorWindow.this.theme().scale(1.0), 1.0);
            double headerRadius = Math.max(WMeteorWindow.this.theme().scale(5.0), 3.0);
            WMeteorWindow.this.roundedQuad(renderer, this.x, this.y, this.width, this.height, headerRadius, headerTop);
            WMeteorWindow.this.roundedQuad(renderer, this.x, this.y, this.width, this.height, headerRadius, headerBottom);
            renderer.quad(this.x, this.y + this.height - line, this.width, line, WMeteorWindow.withAlpha(WMeteorWindow.this.theme().accentColor.get(), this.mouseOver ? 124 : 92));
        }
    }
}

