/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.themes.meteor.widgets.input;

import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorWidget;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.input.WDropdown;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class WMeteorDropdown<T>
extends WDropdown<T>
implements MeteorWidget {
    public WMeteorDropdown(T[] values, T value) {
        super(values, value);
    }

    @Override
    protected WDropdown.WDropdownRoot createRootWidget() {
        return new WRoot();
    }

    @Override
    protected WDropdown.WDropdownValue createValueWidget() {
        return new WValue();
    }

    @Override
    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        MeteorGuiTheme theme = this.theme();
        double pad = this.pad();
        double s = theme.textHeight();
        this.renderBackground(renderer, (WWidget)this, this.pressed, this.mouseOver);
        String text = this.get().toString();
        renderer.text(text, this.x + pad, this.y + pad, theme.textColor.get(), false);
        double rotation = this.expanded ? 180.0 : 0.0;
        renderer.rotatedQuad(this.x + this.width - pad - s, this.y + pad, s, s, rotation, GuiRenderer.TRIANGLE, theme.textSecondaryColor.get());
        if (this.pressed || this.mouseOver) {
            renderer.quad(this.x + pad, this.y + this.height - Math.max(theme.scale(2.0), 1.0), this.width - pad * 2.0, Math.max(theme.scale(1.0), 1.0), WMeteorDropdown.withAlpha(theme.accentColor.get(), this.pressed ? 155 : 95));
        }
    }

    private static Color withAlpha(Color color, int alpha) {
        return new Color(color.r, color.g, color.b, WMeteorDropdown.clamp(alpha));
    }

    private static Color brighten(Color color, int amount) {
        return new Color(WMeteorDropdown.clamp(color.r + amount), WMeteorDropdown.clamp(color.g + amount), WMeteorDropdown.clamp(color.b + amount), color.a);
    }

    private static int clamp(int value) {
        if (value < 0) {
            return 0;
        }
        return Math.min(value, 255);
    }

    private static class WRoot
    extends WDropdown.WDropdownRoot
    implements MeteorWidget {
        private WRoot() {
        }

        @Override
        protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
            MeteorGuiTheme theme = this.theme();
            this.renderBackground(renderer, (WWidget)this, theme.outlineColor.get(), theme.backgroundColor.get());
            renderer.quad(this.x + Math.max(theme.scale(1.0), 1.0), this.y + Math.max(theme.scale(1.0), 1.0), this.width - Math.max(theme.scale(2.0), 2.0), Math.max(theme.scale(1.0), 1.0), WMeteorDropdown.withAlpha(theme.accentColor.get(), 52));
        }
    }

    private class WValue
    extends WDropdown.WDropdownValue
    implements MeteorWidget {
        private WValue() {
            super(WMeteorDropdown.this);
        }

        @Override
        protected void onCalculateSize() {
            double pad = this.pad();
            this.width = pad + this.theme.textWidth(this.value.toString()) + pad;
            this.height = pad + this.theme.textHeight() + pad;
        }

        @Override
        protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
            MeteorGuiTheme theme = this.theme();
            double pad = this.pad();
            boolean selected = WMeteorDropdown.this.value.equals(this.value);
            this.renderBackground(renderer, (WWidget)this, this.pressed, this.mouseOver);
            if (selected) {
                renderer.quad(this.x + Math.max(theme.scale(1.0), 1.0), this.y + Math.max(theme.scale(1.0), 1.0), Math.max(theme.scale(2.0), 1.0), this.height - Math.max(theme.scale(2.0), 2.0), WMeteorDropdown.withAlpha(theme.accentColor.get(), 165));
            }
            Color textColor = this.mouseOver ? WMeteorDropdown.brighten(theme.textColor.get(), 12) : (Color)theme.textColor.get();
            String text = this.value.toString();
            renderer.text(text, this.x + pad, this.y + pad, textColor, false);
        }
    }
}

