/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.themes.meteor.widgets.input;

import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorWidget;
import meteordevelopment.meteorclient.gui.widgets.input.WSlider;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class WMeteorSlider
extends WSlider
implements MeteorWidget {
    public WMeteorSlider(double value, double min, double max) {
        super(value, min, max);
    }

    @Override
    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        double valueWidth = this.valueWidth();
        this.renderBar(renderer, valueWidth);
        this.renderHandle(renderer, valueWidth);
    }

    private void renderBar(GuiRenderer renderer, double valueWidth) {
        MeteorGuiTheme theme = this.theme();
        double s = Math.max(theme.scale(4.0), 2.0);
        double handleSize = this.handleSize();
        double x = this.x + handleSize / 2.0;
        double y = this.y + this.height / 2.0 - s / 2.0;
        double w = this.width - handleSize;
        renderer.quad(x, y, w, s, WMeteorSlider.withAlpha(theme.sliderRight.get(), 205));
        if (valueWidth > 0.0) {
            renderer.quad(x, y, valueWidth, s, WMeteorSlider.brighten(theme.sliderLeft.get(), 16), (Color)theme.sliderLeft.get());
        }
    }

    private void renderHandle(GuiRenderer renderer, double valueWidth) {
        MeteorGuiTheme theme = this.theme();
        double s = this.handleSize();
        double x = this.x + valueWidth;
        double y = this.y;
        renderer.quad(x - Math.max(theme.scale(1.0), 1.0), y - Math.max(theme.scale(1.0), 1.0), s + Math.max(theme.scale(2.0), 2.0), s + Math.max(theme.scale(2.0), 2.0), GuiRenderer.CIRCLE, new Color(0, 0, 0, 90));
        renderer.quad(x, y, s, s, GuiRenderer.CIRCLE, (Color)theme.sliderHandle.get(this.dragging, this.handleMouseOver));
        renderer.quad(x + s * 0.275, y + s * 0.275, s * 0.45, s * 0.45, GuiRenderer.CIRCLE, WMeteorSlider.withAlpha(theme.titleTextColor.get(), 110));
    }

    private static Color withAlpha(Color color, int alpha) {
        return new Color(color.r, color.g, color.b, WMeteorSlider.clamp(alpha));
    }

    private static Color brighten(Color color, int amount) {
        return new Color(WMeteorSlider.clamp(color.r + amount), WMeteorSlider.clamp(color.g + amount), WMeteorSlider.clamp(color.b + amount), color.a);
    }

    private static int clamp(int value) {
        if (value < 0) {
            return 0;
        }
        return Math.min(value, 255);
    }
}

