/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.themes.meteor.widgets.input;

import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorWidget;
import meteordevelopment.meteorclient.gui.themes.meteor.widgets.WMeteorLabel;
import meteordevelopment.meteorclient.gui.utils.CharFilter;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WContainer;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_3532;

public class WMeteorTextBox
extends WTextBox
implements MeteorWidget {
    private boolean cursorVisible;
    private double cursorTimer;
    private double animProgress;

    public WMeteorTextBox(String text, String placeholder, CharFilter filter, Class<? extends WTextBox.Renderer> renderer) {
        super(text, placeholder, filter, renderer);
    }

    @Override
    protected WContainer createCompletionsRootWidget() {
        return new WVerticalList(){

            @Override
            protected void onRender(GuiRenderer renderer1, double mouseX, double mouseY, double delta) {
                MeteorGuiTheme theme1 = WMeteorTextBox.this.theme();
                double s = Math.max(theme1.scale(1.0), 1.0);
                Color outline = WMeteorTextBox.withAlpha(theme1.outlineColor.get(), theme1.outlineColor.get().a + 20);
                SettingColor bg = theme1.backgroundColor.get();
                Color top = WMeteorTextBox.brighten(bg, 10);
                renderer1.quad(this.x, this.y, this.width, this.height, outline);
                renderer1.quad(this.x + s, this.y + s, this.width - s * 2.0, this.height - s * 2.0, top, top, bg, bg);
                renderer1.quad(this.x + s, this.y + s, this.width - s * 2.0, Math.max(theme1.scale(1.0), 1.0), WMeteorTextBox.withAlpha(theme1.accentColor.get(), 64));
            }
        };
    }

    @Override
    protected <T extends WWidget> T createCompletionsValueWidth(String completion, boolean selected) {
        return (T)new CompletionItem(completion, false, selected);
    }

    @Override
    protected void onCursorChanged() {
        this.cursorVisible = true;
        this.cursorTimer = 0.0;
    }

    @Override
    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        if (this.cursorTimer >= 1.0) {
            this.cursorVisible = !this.cursorVisible;
            this.cursorTimer = 0.0;
        } else {
            this.cursorTimer += delta * 1.75;
        }
        MeteorGuiTheme theme = this.theme();
        double pad = this.pad();
        this.renderBackground(renderer, (WWidget)this, this.focused, this.mouseOver);
        if (this.focused) {
            renderer.quad(this.x + pad, this.y + this.height - Math.max(theme.scale(2.0), 1.0), this.width - pad * 2.0, Math.max(theme.scale(1.0), 1.0), WMeteorTextBox.withAlpha(theme.accentColor.get(), 150));
        }
        double overflowWidth = this.getOverflowWidthForRender();
        renderer.scissorStart(this.x + pad, this.y + pad, this.width - pad * 2.0, this.height - pad * 2.0);
        if (!this.text.isEmpty()) {
            this.renderer.render(renderer, this.x + pad - overflowWidth, this.y + pad, this.text, theme.textColor.get());
        } else if (this.placeholder != null) {
            this.renderer.render(renderer, this.x + pad - overflowWidth, this.y + pad, this.placeholder, theme.placeholderColor.get());
        }
        if (this.focused && (this.cursor != this.selectionStart || this.cursor != this.selectionEnd)) {
            double selStart = this.x + pad + this.getTextWidth(this.selectionStart) - overflowWidth;
            double selEnd = this.x + pad + this.getTextWidth(this.selectionEnd) - overflowWidth;
            renderer.quad(selStart, this.y + pad, selEnd - selStart, theme.textHeight(), theme.textHighlightColor.get());
        }
        this.animProgress += delta * 10.0 * (double)(this.focused && this.cursorVisible ? 1 : -1);
        this.animProgress = class_3532.method_15350((double)this.animProgress, (double)0.0, (double)1.0);
        if (this.focused && this.cursorVisible || this.animProgress > 0.0) {
            renderer.setAlpha(this.animProgress);
            renderer.quad(this.x + pad + this.getTextWidth(this.cursor) - overflowWidth, this.y + pad, theme.scale(1.0), theme.textHeight(), theme.textColor.get());
            renderer.setAlpha(1.0);
        }
        renderer.scissorEnd();
    }

    private static Color withAlpha(Color color, int alpha) {
        return new Color(color.r, color.g, color.b, WMeteorTextBox.clamp(alpha));
    }

    private static Color brighten(Color color, int amount) {
        return new Color(WMeteorTextBox.clamp(color.r + amount), WMeteorTextBox.clamp(color.g + amount), WMeteorTextBox.clamp(color.b + amount), color.a);
    }

    private static int clamp(int value) {
        if (value < 0) {
            return 0;
        }
        return Math.min(value, 255);
    }

    private static class CompletionItem
    extends WMeteorLabel
    implements WTextBox.ICompletionItem {
        private static final Color SELECTED_COLOR = new Color(210, 64, 86, 60);
        private boolean selected;

        public CompletionItem(String text, boolean title, boolean selected) {
            super(text, title);
            this.selected = selected;
        }

        @Override
        protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
            super.onRender(renderer, mouseX, mouseY, delta);
            if (this.selected) {
                renderer.quad(this, SELECTED_COLOR);
            }
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        public String getCompletion() {
            return this.text;
        }
    }
}

