/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.themes.meteor.widgets.pressable;

import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.renderer.packer.GuiTexture;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorWidget;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class WMeteorButton
extends WButton
implements MeteorWidget {
    public WMeteorButton(String text, GuiTexture texture) {
        super(text, texture);
    }

    @Override
    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        Color textColor;
        MeteorGuiTheme theme = this.theme();
        double pad = this.pad();
        this.renderBackground(renderer, (WWidget)this, this.pressed, this.mouseOver);
        if (this.pressed || this.mouseOver) {
            int alpha = this.pressed ? 160 : 95;
            renderer.quad(this.x + pad, this.y + this.height - Math.max(theme.scale(2.0), 1.0), this.width - pad * 2.0, Math.max(theme.scale(1.0), 1.0), WMeteorButton.withAlpha(theme.accentColor.get(), alpha));
        }
        Color color = this.pressed ? (Color)theme.titleTextColor.get() : (textColor = this.mouseOver ? WMeteorButton.brighten(theme.textColor.get(), 14) : (Color)theme.textColor.get());
        if (this.text != null) {
            renderer.text(this.text, this.x + this.width / 2.0 - this.textWidth / 2.0, this.y + pad, textColor, false);
        } else {
            double ts = theme.textHeight();
            renderer.quad(this.x + this.width / 2.0 - ts / 2.0, this.y + pad, ts, ts, this.texture, textColor);
        }
    }

    private static Color withAlpha(Color color, int alpha) {
        return new Color(color.r, color.g, color.b, WMeteorButton.clamp(alpha));
    }

    private static Color brighten(Color color, int amount) {
        return new Color(WMeteorButton.clamp(color.r + amount), WMeteorButton.clamp(color.g + amount), WMeteorButton.clamp(color.b + amount), color.a);
    }

    private static int clamp(int value) {
        if (value < 0) {
            return 0;
        }
        return Math.min(value, 255);
    }
}

