/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.pathing;

import baritone.api.BaritoneAPI;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalGetToBlock;
import baritone.api.pathing.goals.GoalXZ;
import baritone.api.process.IBaritoneProcess;
import baritone.api.process.PathingCommand;
import baritone.api.process.PathingCommandType;
import baritone.api.utils.SettingsUtil;
import java.util.function.Predicate;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.pathing.BaritoneSettings;
import meteordevelopment.meteorclient.pathing.IPathManager;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class BaritonePathManager
implements IPathManager {
    private final BaritoneSettings settings;
    private GoalDirection directionGoal;
    private boolean pathingPaused;

    public BaritonePathManager() {
        MeteorClient.EVENT_BUS.subscribe((Object)this);
        this.settings = new BaritoneSettings();
        BaritoneAPI.getProvider().getPrimaryBaritone().getPathingControlManager().registerProcess((IBaritoneProcess)new BaritoneProcess());
    }

    @Override
    public String getName() {
        return "Baritone";
    }

    @Override
    public boolean isPathing() {
        return BaritoneAPI.getProvider().getPrimaryBaritone().getPathingBehavior().isPathing();
    }

    @Override
    public void pause() {
        this.pathingPaused = true;
    }

    @Override
    public void resume() {
        this.pathingPaused = false;
    }

    @Override
    public void stop() {
        BaritoneAPI.getProvider().getPrimaryBaritone().getPathingBehavior().cancelEverything();
    }

    @Override
    public void moveTo(class_2338 pos, boolean ignoreY) {
        if (ignoreY) {
            BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().setGoalAndPath((Goal)new GoalXZ(pos.method_10263(), pos.method_10260()));
            return;
        }
        BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().setGoalAndPath((Goal)new GoalGetToBlock(pos));
    }

    @Override
    public void moveInDirection(float yaw) {
        this.directionGoal = new GoalDirection(yaw);
        BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().setGoalAndPath((Goal)this.directionGoal);
    }

    @Override
    public void mine(class_2248 ... blocks) {
        BaritoneAPI.getProvider().getPrimaryBaritone().getMineProcess().mine(blocks);
    }

    @Override
    public void follow(Predicate<class_1297> entity) {
        BaritoneAPI.getProvider().getPrimaryBaritone().getFollowProcess().follow(entity);
    }

    @Override
    public float getTargetYaw() {
        return BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext().playerRotations().getYaw();
    }

    @Override
    public float getTargetPitch() {
        return BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext().playerRotations().getPitch();
    }

    @Override
    public IPathManager.ISettings getSettings() {
        return this.settings;
    }

    @EventHandler(priority=200)
    private void onTick(TickEvent.Pre event) {
        if (this.directionGoal == null) {
            return;
        }
        if (this.directionGoal != BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().getGoal()) {
            this.directionGoal = null;
            return;
        }
        this.directionGoal.tick();
    }

    private class BaritoneProcess
    implements IBaritoneProcess {
        private BaritoneProcess() {
        }

        public boolean isActive() {
            return BaritonePathManager.this.pathingPaused;
        }

        public PathingCommand onTick(boolean b, boolean b1) {
            BaritoneAPI.getProvider().getPrimaryBaritone().getInputOverrideHandler().clearAllKeys();
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }

        public boolean isTemporary() {
            return true;
        }

        public void onLostControl() {
        }

        public double priority() {
            return 0.0;
        }

        public String displayName0() {
            return "SoulReaver Client";
        }
    }

    private static class GoalDirection
    implements Goal {
        private static final double SQRT_2 = Math.sqrt(2.0);
        private final float yaw;
        private int x;
        private int z;
        private int timer;

        public GoalDirection(float yaw) {
            this.yaw = yaw;
            this.tick();
        }

        public static double calculate(double xDiff, double zDiff) {
            double straight;
            double z;
            double x = Math.abs(xDiff);
            if (x < (z = Math.abs(zDiff))) {
                straight = z - x;
                diagonal = x;
            } else {
                straight = x - z;
                diagonal = z;
            }
            return ((diagonal *= SQRT_2) + straight) * (Double)BaritoneAPI.getSettings().costHeuristic.value;
        }

        public void tick() {
            if (this.timer <= 0) {
                this.timer = 20;
                class_243 pos = MeteorClient.mc.field_1724.method_73189();
                float theta = (float)Math.toRadians(this.yaw);
                this.x = (int)Math.floor(pos.field_1352 - (double)class_3532.method_15374((double)theta) * 100.0);
                this.z = (int)Math.floor(pos.field_1350 + (double)class_3532.method_15362((double)theta) * 100.0);
            }
            --this.timer;
        }

        public boolean isInGoal(int x, int y, int z) {
            return x == this.x && z == this.z;
        }

        public double heuristic(int x, int y, int z) {
            int xDiff = x - this.x;
            int zDiff = z - this.z;
            return GoalDirection.calculate(xDiff, zDiff);
        }

        public String toString() {
            return String.format("GoalXZ{x=%s,z=%s}", SettingsUtil.maybeCensor((int)this.x), SettingsUtil.maybeCensor((int)this.z));
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }
    }
}

