/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.hud.elements;

import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.TickRate;

public class LagNotifierHud
extends HudElement {
    public static final HudElementInfo<LagNotifierHud> INFO = new HudElementInfo<LagNotifierHud>(Hud.GROUP, "lag-notifier", "Displays if the server is lagging in ticks.", LagNotifierHud::new);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgScale;
    private final SettingGroup sgBackground;
    private final Setting<Boolean> shadow;
    private final Setting<SettingColor> textColor;
    private final Setting<SettingColor> color1;
    private final Setting<SettingColor> color2;
    private final Setting<SettingColor> color3;
    private final Setting<Boolean> customScale;
    private final Setting<Double> scale;
    private final Setting<Boolean> background;
    private final Setting<SettingColor> backgroundColor;

    public LagNotifierHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgScale = this.settings.createGroup("Scale");
        this.sgBackground = this.settings.createGroup("Background");
        this.shadow = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shadow")).description("Text shadow.")).defaultValue(true)).build());
        this.textColor = this.sgGeneral.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("text-color")).description("A.")).defaultValue(new SettingColor()).build());
        this.color1 = this.sgGeneral.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("color-1")).description("First color.")).defaultValue(new SettingColor(255, 255, 5)).build());
        this.color2 = this.sgGeneral.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("color-2")).description("Second color.")).defaultValue(new SettingColor(235, 158, 52)).build());
        this.color3 = this.sgGeneral.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("color-3")).description("Third color.")).defaultValue(new SettingColor(225, 45, 45)).build());
        this.customScale = this.sgScale.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("custom-scale")).description("Applies a custom scale to this hud element.")).defaultValue(false)).build());
        this.scale = this.sgScale.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Custom scale.")).visible(this.customScale::get)).defaultValue(1.0).min(0.5).sliderRange(0.5, 3.0).build());
        this.background = this.sgBackground.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue(false)).build());
        this.backgroundColor = this.sgBackground.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(this.background::get)).defaultValue(new SettingColor(25, 25, 25, 50)).build());
    }

    @Override
    public void render(HudRenderer renderer) {
        float timeSinceLastTick = TickRate.INSTANCE.getTimeSinceLastTick();
        if (timeSinceLastTick < 1.1f && !this.isInEditor()) {
            return;
        }
        Color color = this.isInEditor() || timeSinceLastTick > 10.0f ? (Color)this.color3.get() : (timeSinceLastTick > 3.0f ? (Color)this.color2.get() : (Color)this.color1.get());
        String info = this.isInEditor() ? "10.2" : String.format("%.1f", Float.valueOf(timeSinceLastTick));
        this.render(renderer, info, color);
        if (this.background.get().booleanValue()) {
            renderer.quad(this.x, this.y, this.getWidth(), this.getHeight(), this.backgroundColor.get());
        }
    }

    private void render(HudRenderer renderer, String right, Color rightColor) {
        double x2 = renderer.text("Time since last tick ", this.x, this.y, this.textColor.get(), this.shadow.get(), this.getScale());
        x2 = renderer.text(right, x2, this.y, rightColor, this.shadow.get(), this.getScale());
        this.setSize(x2 - (double)this.x, renderer.textHeight(this.shadow.get(), this.getScale()));
    }

    private double getScale() {
        return this.customScale.get() != false ? this.scale.get().doubleValue() : Hud.get().getTextScale();
    }
}

