/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.entity.simulator;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.mixin.CrossbowItemAccessor;
import meteordevelopment.meteorclient.mixin.ProjectileInGroundAccessor;
import meteordevelopment.meteorclient.mixininterface.IVec3d;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.movement.NoSlow;
import meteordevelopment.meteorclient.systems.modules.movement.Sneak;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.entity.simulator.SimulationStep;
import meteordevelopment.meteorclient.utils.player.Rotations;
import net.minecraft.class_10690;
import net.minecraft.class_10691;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1668;
import net.minecraft.class_1673;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1679;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1682;
import net.minecraft.class_1683;
import net.minecraft.class_1684;
import net.minecraft.class_1685;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1771;
import net.minecraft.class_1776;
import net.minecraft.class_1779;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_1823;
import net.minecraft.class_1828;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_8949;
import net.minecraft.class_9109;
import net.minecraft.class_9236;
import net.minecraft.class_9239;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class ProjectileEntitySimulator {
    private final class_2338.class_2339 blockPos = new class_2338.class_2339();
    private final class_243 pos3d = new class_243(0.0, 0.0, 0.0);
    private final class_243 prevPos3d = new class_243(0.0, 0.0, 0.0);
    public final Vector3d pos = new Vector3d();
    private final Vector3d velocity = new Vector3d();
    private class_1676 simulatingEntity;
    private class_4048 dimensions;
    private int age;
    private int pierceLevel;
    private double gravity;
    private float airDrag;
    private float waterDrag;
    private boolean isTouchingWater;
    private static final MotionData EGG = new MotionData(1.5f, 0.0f, 0.03, 0.99f, 0.8f, class_1299.field_6144);
    private static final MotionData ENDER_PEARL = new MotionData(1.5f, 0.0f, 0.03, 0.99f, 0.8f, class_1299.field_6082);
    private static final MotionData SNOWBALL = new MotionData(1.5f, 0.0f, 0.03, 0.99f, 0.8f, class_1299.field_6068);
    private static final MotionData EXPERIENCE_BOTTLE = new MotionData(0.7f, -20.0f, 0.07, 0.99f, 0.8f, class_1299.field_6064);
    private static final MotionData LINGERING_POTION = new MotionData(0.5f, -20.0f, 0.05, 0.99f, 0.8f, class_1299.field_56255);
    private static final MotionData SPLASH_POTION = new MotionData(0.5f, -20.0f, 0.05, 0.99f, 0.8f, class_1299.field_56254);
    private static final MotionData EXPLOSIVE = new MotionData(0.0f, 0.0f, 0.0, 1.0f, 1.0f, null);
    private static final MotionData WIND_CHARGE = new MotionData(1.5f, 0.0f, 0.0, 1.0f, 1.0f, class_1299.field_47243);
    private static final MotionData ARROW = new MotionData(0.0f, 0.0f, 0.05, 0.99f, 0.6f, class_1299.field_6122);
    private static final MotionData TRIDENT = new MotionData(2.5f, 0.0f, 0.05, 0.99f, 0.99f, class_1299.field_6127);
    private static final MotionData FIREWORK_ROCKET = new MotionData(0.0f, 0.0f, 0.0, 1.0f, 1.0f, class_1299.field_6133);
    private static final MotionData FISHING_BOBBER = new MotionData(0.0f, 0.0f, 0.03, 0.92f, 0.0f, class_1299.field_6103);
    private static final MotionData LLAMA_SPIT = new MotionData(1.5f, 0.0f, 0.06, 0.99f, 0.0f, class_1299.field_6124);

    public boolean set(class_1297 user, class_1799 itemStack, double angleOffset, boolean accurate, float tickDelta) {
        class_1792 item;
        class_1792 class_17922 = item = itemStack.method_7909();
        Objects.requireNonNull(class_17922);
        class_1792 class_17923 = class_17922;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1753.class, class_1764.class, class_9239.class, class_1835.class, class_1823.class, class_1771.class, class_1776.class, class_1779.class, class_1828.class, class_1803.class, class_1787.class}, (Object)class_17923, n)) {
            case 0: {
                class_1753 ignored = (class_1753)class_17923;
                if (!(user instanceof class_1309)) {
                    return false;
                }
                class_1309 livingEntity = (class_1309)user;
                float charge = class_1753.method_7722((int)livingEntity.method_6048());
                if ((double)charge <= 0.1) {
                    if (user == MeteorClient.mc.field_1724) {
                        charge = 1.0f;
                    } else {
                        return false;
                    }
                }
                this.set(user, angleOffset, accurate, tickDelta, ARROW.withPower(charge * 3.0f));
                break;
            }
            case 1: {
                class_1764 ignored = (class_1764)class_17923;
                class_9278 projectilesComponent = (class_9278)itemStack.method_58694(class_9334.field_49649);
                if (projectilesComponent == null) {
                    return false;
                }
                float speed = CrossbowItemAccessor.meteor$getSpeed(projectilesComponent);
                if (projectilesComponent.method_57438(class_1802.field_8639)) {
                    this.set(user, angleOffset, accurate, tickDelta, FIREWORK_ROCKET.withPower(speed));
                } else {
                    this.set(user, angleOffset, accurate, tickDelta, ARROW.withPower(speed));
                }
                this.pierceLevel = projectilesComponent.method_57438(class_1802.field_8639) ? 0 : Utils.getEnchantmentLevel(itemStack, (class_5321<class_1887>)class_1893.field_9132);
                break;
            }
            case 2: {
                class_9239 ignored = (class_9239)class_17923;
                this.set(user, angleOffset, accurate, tickDelta, WIND_CHARGE);
                break;
            }
            case 3: {
                class_1835 ignored = (class_1835)class_17923;
                this.set(user, angleOffset, accurate, tickDelta, TRIDENT);
                break;
            }
            case 4: {
                class_1823 ignored = (class_1823)class_17923;
                this.set(user, angleOffset, accurate, tickDelta, SNOWBALL);
                break;
            }
            case 5: {
                class_1771 ignored = (class_1771)class_17923;
                this.set(user, angleOffset, accurate, tickDelta, EGG);
                break;
            }
            case 6: {
                class_1776 ignored = (class_1776)class_17923;
                this.set(user, angleOffset, accurate, tickDelta, ENDER_PEARL);
                break;
            }
            case 7: {
                class_1779 ignored = (class_1779)class_17923;
                this.set(user, angleOffset, accurate, tickDelta, EXPERIENCE_BOTTLE);
                break;
            }
            case 8: {
                class_1828 ignored = (class_1828)class_17923;
                this.set(user, angleOffset, accurate, tickDelta, SPLASH_POTION);
                break;
            }
            case 9: {
                class_1803 ignored = (class_1803)class_17923;
                this.set(user, angleOffset, accurate, tickDelta, LINGERING_POTION);
                break;
            }
            case 10: {
                class_1787 ignored = (class_1787)class_17923;
                this.setFishingBobber(user, tickDelta, FISHING_BOBBER);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void set(class_1297 user, double angleOffset, boolean accurate, float tickDelta, MotionData data) {
        double z;
        double y;
        double x;
        double pitch;
        double yaw;
        class_4050 pose = user.method_18376();
        if (user == MeteorClient.mc.field_1724 && (Modules.get().get(NoSlow.class).airStrict() || Modules.get().get(Sneak.class).doPacket())) {
            pose = class_4050.field_18081;
        }
        Utils.set(this.pos, user, tickDelta).add(0.0, (double)(user.method_18381(pose) - 0.1f), 0.0);
        if (user == MeteorClient.mc.field_1724 && Rotations.rotating) {
            yaw = Rotations.serverYaw;
            pitch = Rotations.serverPitch;
        } else {
            yaw = user.method_5705(tickDelta);
            pitch = user.method_5695(tickDelta);
        }
        if (angleOffset == 0.0) {
            x = -Math.sin(yaw * 0.017453292) * Math.cos(pitch * 0.017453292);
            y = -Math.sin((pitch + (double)data.roll()) * 0.017453292);
            z = Math.cos(yaw * 0.017453292) * Math.cos(pitch * 0.017453292);
        } else {
            class_243 oppositeRotationVec = user.method_18864(1.0f);
            Quaterniond quaternion = new Quaterniond().setAngleAxis(angleOffset, oppositeRotationVec.field_1352, oppositeRotationVec.field_1351, oppositeRotationVec.field_1350);
            class_243 rotationVec = user.method_5828(1.0f);
            Vector3d vector3d = new Vector3d(rotationVec.field_1352, rotationVec.field_1351, rotationVec.field_1350);
            vector3d.rotate((Quaterniondc)quaternion);
            x = vector3d.x;
            y = vector3d.y;
            z = vector3d.z;
        }
        this.velocity.set(x, y, z).normalize().mul((double)data.power());
        if (accurate) {
            class_243 vel = user.method_60478();
            this.velocity.add(vel.field_1352, user.method_24828() ? 0.0 : vel.field_1351, vel.field_1350);
        }
        this.setSimulationData((class_1676)data.entity().method_5883((class_1937)MeteorClient.mc.field_1687, null), data);
    }

    public void setFishingBobber(class_1297 user, float tickDelta, MotionData data) {
        double pitch;
        double yaw;
        if (user == MeteorClient.mc.field_1724 && Rotations.rotating) {
            yaw = Rotations.serverYaw;
            pitch = Rotations.serverPitch;
        } else {
            yaw = user.method_5705(tickDelta);
            pitch = user.method_5695(tickDelta);
        }
        double h = Math.cos(-yaw * 0.01745329238474369 - 3.1415927410125732);
        double i = Math.sin(-yaw * 0.01745329238474369 - 3.1415927410125732);
        double j = -Math.cos(-pitch * 0.01745329238474369);
        double k = Math.sin(-pitch * 0.01745329238474369);
        class_4050 pose = user.method_18376();
        if (user == MeteorClient.mc.field_1724 && (Modules.get().get(NoSlow.class).airStrict() || Modules.get().get(Sneak.class).doPacket())) {
            pose = class_4050.field_18081;
        }
        Utils.set(this.pos, user, tickDelta).sub(i * 0.3, 0.0, h * 0.3).add(0.0, (double)user.method_18381(pose), 0.0);
        this.velocity.set(-i, class_3532.method_15350((double)(-(k / j)), (double)-5.0, (double)5.0), -h);
        double l = this.velocity.length();
        this.velocity.mul(0.6 / l + 0.5, 0.6 / l + 0.5, 0.6 / l + 0.5);
        this.setSimulationData((class_1676)data.entity().method_5883((class_1937)MeteorClient.mc.field_1687, null), data);
    }

    public boolean set(class_1297 entity) {
        ProjectileInGroundAccessor ppe;
        if (entity instanceof ProjectileInGroundAccessor && (ppe = (ProjectileInGroundAccessor)entity).meteor$invokeIsInGround()) {
            return false;
        }
        class_1297 class_12972 = entity;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1667.class, class_1679.class, class_1685.class, class_1684.class, class_1680.class, class_1681.class, class_1683.class, class_10691.class, class_10690.class, class_9236.class, class_1668.class, class_1673.class}, (Object)class_12973, n)) {
            case 0: {
                class_1667 e = (class_1667)class_12973;
                this.set((class_1676)e, ARROW);
                break;
            }
            case 1: {
                class_1679 e = (class_1679)class_12973;
                this.set((class_1676)e, ARROW);
                break;
            }
            case 2: {
                class_1685 e = (class_1685)class_12973;
                this.set((class_1676)e, TRIDENT);
                break;
            }
            case 3: {
                class_1684 e = (class_1684)class_12973;
                this.set((class_1676)e, ENDER_PEARL);
                break;
            }
            case 4: {
                class_1680 e = (class_1680)class_12973;
                this.set((class_1676)e, SNOWBALL);
                break;
            }
            case 5: {
                class_1681 e = (class_1681)class_12973;
                this.set((class_1676)e, EGG);
                break;
            }
            case 6: {
                class_1683 e = (class_1683)class_12973;
                this.set((class_1676)e, EXPERIENCE_BOTTLE);
                break;
            }
            case 7: {
                class_10691 e = (class_10691)class_12973;
                this.set((class_1676)e, SPLASH_POTION);
                break;
            }
            case 8: {
                class_10690 e = (class_10690)class_12973;
                this.set((class_1676)e, LINGERING_POTION);
                break;
            }
            case 9: {
                class_9236 e = (class_9236)class_12973;
                this.set((class_1676)e, WIND_CHARGE);
                break;
            }
            case 10: {
                class_1668 e = (class_1668)class_12973;
                this.set((class_1676)e, EXPLOSIVE);
                break;
            }
            case 11: {
                class_1673 e = (class_1673)class_12973;
                this.set((class_1676)e, LLAMA_SPIT);
                break;
            }
            default: {
                return false;
            }
        }
        if (entity.method_5740()) {
            this.gravity = 0.0;
        }
        return true;
    }

    public void set(class_1676 entity, MotionData data) {
        this.pos.set(entity.method_23317(), entity.method_23318(), entity.method_23321());
        double speed = entity.method_18798().method_1033();
        this.velocity.set(entity.method_18798().field_1352, entity.method_18798().field_1351, entity.method_18798().field_1350).normalize().mul(speed);
        this.setSimulationData(entity, data);
    }

    private void setSimulationData(class_1676 entity, MotionData data) {
        this.gravity = data.gravity();
        this.airDrag = data.airDrag();
        this.waterDrag = data.waterDrag();
        this.simulatingEntity = entity;
        this.dimensions = this.simulatingEntity.method_18377(this.simulatingEntity.method_18376());
        this.isTouchingWater = this.simulatingEntity.method_5799();
        this.age = this.simulatingEntity.field_6012;
        this.pierceLevel = 0;
    }

    public SimulationStep tick() {
        ++this.age;
        ((IVec3d)this.prevPos3d).meteor$set(this.pos);
        if (this.simulatingEntity instanceof class_1682 || this.simulatingEntity instanceof class_1668) {
            this.velocity.sub(0.0, this.gravity, 0.0);
            this.velocity.mul(this.isTouchingWater ? (double)this.waterDrag : (double)this.airDrag);
            this.pos.add((Vector3dc)this.velocity);
            this.tickIsTouchingWater();
        } else if (this.simulatingEntity instanceof class_1665 || this.simulatingEntity instanceof class_1673) {
            this.pos.add((Vector3dc)this.velocity);
            this.velocity.mul(this.isTouchingWater ? (double)this.waterDrag : (double)this.airDrag);
            this.velocity.sub(0.0, this.gravity, 0.0);
            this.tickIsTouchingWater();
        } else if (this.simulatingEntity instanceof class_1676) {
            this.tickIsTouchingWater();
            this.velocity.sub(0.0, this.gravity, 0.0);
            this.pos.add((Vector3dc)this.velocity);
            this.velocity.mul(this.isTouchingWater ? (double)this.waterDrag : (double)this.airDrag);
        }
        if (this.pos.y < (double)MeteorClient.mc.field_1687.method_31607()) {
            return SimulationStep.MISS;
        }
        int chunkX = class_4076.method_32204((double)this.pos.x);
        int chunkZ = class_4076.method_32204((double)this.pos.z);
        if (!MeteorClient.mc.field_1687.method_2935().method_12123(chunkX, chunkZ)) {
            return SimulationStep.MISS;
        }
        ((IVec3d)this.pos3d).meteor$set(this.pos);
        if (this.pos3d.equals((Object)this.prevPos3d)) {
            return SimulationStep.MISS;
        }
        return this.getCollision();
    }

    public void tickIsTouchingWater() {
        class_238 box = this.dimensions.method_30231(this.pos.x, this.pos.y, this.pos.z).method_1011(0.001);
        int minX = class_3532.method_15357((double)box.field_1323);
        int maxX = class_3532.method_15384((double)box.field_1320);
        int minY = class_3532.method_15357((double)box.field_1322);
        int maxY = class_3532.method_15384((double)box.field_1325);
        int minZ = class_3532.method_15357((double)box.field_1321);
        int maxZ = class_3532.method_15384((double)box.field_1324);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    double fluidY;
                    this.blockPos.method_10103(x, y, z);
                    class_3610 fluidState = MeteorClient.mc.field_1687.method_8316((class_2338)this.blockPos);
                    if (!fluidState.method_15767(class_3486.field_15517) || !((fluidY = (double)((float)y + fluidState.method_15763((class_1922)MeteorClient.mc.field_1687, (class_2338)this.blockPos))) >= box.field_1322)) continue;
                    this.isTouchingWater = true;
                    return;
                }
            }
        }
        this.isTouchingWater = false;
    }

    private SimulationStep getCollision() {
        class_3966 ehr;
        class_3965 blockCollision = MeteorClient.mc.field_1687.method_61717(new class_3959(this.prevPos3d, this.pos3d, class_3959.class_3960.field_17558, this.waterDrag == 0.0f ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, (class_1297)this.simulatingEntity));
        if (blockCollision.method_17783() != class_239.class_240.field_1333) {
            ((IVec3d)this.pos3d).meteor$set(blockCollision.method_17784());
        }
        if (this.simulatingEntity instanceof class_1665) {
            class_3966 result;
            boolean hit;
            Collection entityCollisions = class_1675.method_75215((class_1937)MeteorClient.mc.field_1687, (class_1297)this.simulatingEntity, (class_243)this.prevPos3d, (class_243)this.pos3d, (class_238)this.dimensions.method_30757(this.prevPos3d).method_1012(this.velocity.x, this.velocity.y, this.velocity.z).method_1014(1.0), entity -> !entity.method_7325() && entity.method_5805() && entity.method_5863(), (float)this.getToleranceMargin(), (class_3959.class_3960)class_3959.class_3960.field_17558, (boolean)false);
            entityCollisions.removeIf(collision -> this.age <= 1 && collision.method_17782() == MeteorClient.mc.field_1724);
            if (entityCollisions.isEmpty()) {
                return new SimulationStep(this.hitOrDeflect((class_239)blockCollision), new class_239[]{blockCollision});
            }
            boolean stop = false;
            ArrayList<class_3966> hits = new ArrayList<class_3966>();
            Iterator iterator = entityCollisions.iterator();
            while (iterator.hasNext() && (hit = this.hitOrDeflect((class_239)(result = (class_3966)iterator.next())))) {
                hits.add(result);
                if (this.pierceLevel <= 0) {
                    stop = true;
                    break;
                }
                --this.pierceLevel;
            }
            return new SimulationStep(stop, hits.toArray(new class_239[0]));
        }
        class_3966 entityCollision = class_1675.method_37226((class_1937)MeteorClient.mc.field_1687, (class_1297)this.simulatingEntity, (class_243)this.prevPos3d, (class_243)this.pos3d, (class_238)this.dimensions.method_30757(this.prevPos3d).method_1012(this.velocity.x, this.velocity.y, this.velocity.z).method_1014(1.0), entity -> !entity.method_7325() && entity.method_5805() && entity.method_5863(), (float)this.getToleranceMargin());
        if (entityCollision == null || this.age <= 1 && entityCollision instanceof class_3966 && (ehr = entityCollision).method_17782() == MeteorClient.mc.field_1724) {
            return new SimulationStep(this.hitOrDeflect((class_239)blockCollision), new class_239[]{blockCollision});
        }
        if (this.hitOrDeflect((class_239)entityCollision)) {
            return new SimulationStep(true, new class_239[]{entityCollision});
        }
        return new SimulationStep(false, new class_239[0]);
    }

    private boolean hitOrDeflect(class_239 hitResult) {
        if (hitResult instanceof class_3966) {
            class_1309 livingEntity;
            class_3966 entityHitResult = (class_3966)hitResult;
            class_1297 entity = entityHitResult.method_17782();
            Utils.set(this.pos, entityHitResult.method_17784());
            if (entity instanceof class_8949 && !(this.simulatingEntity instanceof class_9236) || entity.method_56071(this.simulatingEntity) == class_9109.field_48348) {
                this.velocity.mul(-0.5);
                return false;
            }
            if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6039() && this.simulatingEntity instanceof class_1665) {
                this.velocity.mul(-0.5).mul(0.2);
                return this.velocity.lengthSquared() < 1.0E-7;
            }
            return true;
        }
        if (hitResult instanceof class_3965) {
            class_3965 bhr = (class_3965)hitResult;
            Utils.set(this.pos, bhr.method_17784());
            if (this.simulatingEntity.method_62823() && bhr.method_62877()) {
                this.velocity.mul(-0.5).mul(0.2);
                return false;
            }
            return bhr.method_17783() != class_239.class_240.field_1333;
        }
        return false;
    }

    private float getToleranceMargin() {
        return Math.max(0.0f, Math.min(0.3f, (float)(this.age - 2) / 20.0f));
    }

    public record MotionData(float power, float roll, double gravity, float airDrag, float waterDrag, class_1299<?> entity) {
        public MotionData withPower(float power) {
            return new MotionData(power, this.roll(), this.gravity(), this.airDrag(), this.waterDrag(), this.entity());
        }
    }
}

